# Laravel AI Asset & Fleet Management SaaS
# PoultryOps AI (Broiler Operations MVP)

## Overview
This project is a Laravel-based Software as a Service (SaaS) solution designed for asset and fleet management with a multi-tenant architecture. It is specifically tailored for the mining, quarrying, and construction industries. The application provides tools for managing assets, vehicles, telemetry data, trips, maintenance records, and alerts, along with AI-driven automation features and a robust API for integration with other systems.

PoultryOps AI is an additional MVP module for broiler operations. It adds multi-house poultry tracking, ESP32-CAM behavior monitoring, sensor ingestion, load-cell weight sampling, AI analytics, and Telegram notifications.

## Features
- Multi-tenant architecture for managing multiple clients
- User authentication and role-based access control (RBAC)
- Tenant management for creating, updating, and deleting tenants
- Sites/locations, asset assignments, and audit logging
- Asset lifecycle tracking including registration, updates, and maintenance
- Work orders, PM schedules, checklists, downtime, and cost tracking
- Vehicle management with telemetry data ingestion and processing
- Fuel logs, tyre management, parts & inventory, and vendor management
- Maintenance scheduling and work order management
- Trip management for efficient logistics
- AI-driven automation for asset management and operational efficiency
- AI-assisted imports for asset registers, service sheets, and invoices
- AI maintenance insights (root cause suggestions, PM interval recommendations)
- Sensor ingestion pipeline with rules-based alarms and notifications
- Alert system for maintenance and operational issues
- KPI tracking and reporting for performance analysis
- Dashboard for real-time insights and analytics
- PoultryOps AI: multi-house broiler monitoring, alerts, AI summaries, Telegram notifications

## Installation
1. Clone the repository:
   ```
   git clone https://github.com/yourusername/laravel-ai-asset-fleet-saas.git
   ```
2. Navigate to the project directory:
   ```
   cd laravel-ai-asset-fleet-saas
   ```
3. Ensure PHP 8.2+ is available. If you do not have PHP 8.2 installed, you can use the bundled binary:
   ```
   # Windows (PowerShell)
   .\tools\php-8.2.30\php.exe tools\composer.phar install
   ```
   When using the bundled PHP, prefix artisan commands with `.\tools\php-8.2.30\php.exe`.
4. Install dependencies:
   ```
   composer install
   npm install
   ```
5. Copy the `.env.example` to `.env` and configure your environment variables:
   ```
   cp .env.example .env
   ```
   The default `.env.example` is configured for MySQL/MariaDB. Create the database and update credentials.
6. Generate the application key:
   ```
   php artisan key:generate
   ```
7. Run the migrations:
   ```
   php artisan migrate
   ```
8. Create the storage symlink for camera frames:
   ```
   php artisan storage:link
   ```
9. Seed the database (optional):
   ```
   php artisan db:seed
   ```
10. Start the development server:
   ```
   php artisan serve
   ```

## Background Jobs
Imports, sensor normalization, and weekly KPI reports are queued. In development you can keep `QUEUE_CONNECTION=sync` or switch to database queues:
```
php artisan migrate
php artisan queue:work
```

For PoultryOps AI, database queues are recommended:
```
php artisan queue:table
php artisan migrate
php artisan queue:work
```

## PoultryOps AI Quick Start
1. Seed demo poultry data:
   ```
   php artisan poultry:seed-demo
   ```
2. Generate AI summaries:
   ```
   php artisan poultry:run-ai --period=daily
   php artisan poultry:run-ai --period=weekly
   ```
3. Evaluate alerts on demand:
   ```
   php artisan poultry:evaluate-alerts
   ```

## PoultryOps IoT Endpoints
All IoT routes use `X-DEVICE-KEY` header authentication.
- `POST /api/iot/sensors/reading`
- `POST /api/iot/scale/weight`
- `POST /api/iot/cam/frame`
- `POST /api/iot/cam/event`

## Scheduler
Add the Laravel scheduler to cron (every minute). PoultryOps tasks:
- Daily AI summary at 18:00
- Weekly digest Friday 16:00
- Alert evaluation every 5 minutes

## Folder Structure
- `app/`: Contains the core application logic including models, controllers, and services.
- `bootstrap/`: Contains the files for bootstrapping the application.
- `config/`: Configuration files for various services and settings.
- `database/`: Contains migrations, seeders, and factories for database management.
- `docs/`: Documentation files including API routes, RBAC roles, multi-tenancy architecture, and AI automation.
- `public/`: Publicly accessible files including the entry point for the application.
- `resources/`: Contains views, JavaScript, and CSS files.
- `routes/`: Defines the API and web routes for the application.
- `storage/`: Storage for logs, cache, and other files.
- `tests/`: Contains feature and unit tests for the application.

## API Documentation
Refer to the `docs/API_ROUTES.md` for detailed API endpoints and usage.

## RBAC Roles
Refer to the `docs/RBAC_ROLES.md` for a detailed description of user roles and permissions.

## Multi-Tenancy
Refer to the `docs/MULTI_TENANCY.md` for information on the multi-tenancy architecture and implementation.

## AI Automation
Refer to the `docs/AI_AUTOMATION.md` for details on AI-driven features and automation processes.

## KPI Formulas
Refer to the `docs/KPI_FORMULAS.md` for key performance indicators and their calculations.

## Contributing
Contributions are welcome! Please submit a pull request or open an issue for any enhancements or bug fixes.

## CI Deployment Gate
- A GitHub Actions workflow is included at `.github/workflows/public-launch-hardening.yml`.
- It runs `tests/Feature/PublicLaunchHardeningAuditTest.php` on pull requests and pushes to `main`/`master`.
- To make this block production deploys, set **Link/Image Regression Gate** as a required status check in your branch protection rules.

## License
This project is licensed under the MIT License. See the LICENSE file for details.
