<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Tenant;
use App\Services\PurchaseRequestEstimatorService;

class BackfillPurchaseRequestEstimates extends Command
{
    protected $signature = 'purchase-requests:estimate {--tenant=} {--site=} {--fx=13500} {--contingency=0.12}';

    protected $description = 'Backfill missing purchase request details with estimated USD/ZWL values.';

    public function handle(PurchaseRequestEstimatorService $service): int
    {
        $tenantId = $this->option('tenant');
        $site = $this->option('site') ?: 'Goromonzi Quarry';
        $tenant = $tenantId ? Tenant::find($tenantId) : Tenant::where('name', 'Fourways Group')->first();

        if (!$tenant) {
            $this->error('Tenant not found.');
            return self::FAILURE;
        }

        $result = $service->backfillForSite(
            $tenant->id,
            $site,
            (float) $this->option('fx'),
            (float) $this->option('contingency')
        );

        $this->info('Backfill complete.');
        foreach ($result as $key => $value) {
            $this->line($key . ': ' . $value);
        }

        return self::SUCCESS;
    }
}
