<?php

namespace App\Console\Commands;

use App\Models\Tenant;
use App\Services\WeeklyAiAgentsReportService;
use Illuminate\Console\Command;

class GenerateWeeklyAiAgentsReport extends Command
{
    protected $signature = 'reports:weekly-ai-agents {--tenant=} {--week=} {--force} {--window=}';

    protected $description = 'Generate weekly AI agents report PDF per tenant.';

    public function handle(WeeklyAiAgentsReportService $service): int
    {
        $tenantOption = $this->option('tenant');
        $week = $this->option('week');
        $force = (bool) $this->option('force');
        $window = $this->option('window');

        $tenants = $tenantOption
            ? Tenant::where('id', (int) $tenantOption)->get()
            : Tenant::all();

        if ($tenants->isEmpty()) {
            $this->warn('No tenants found for report generation.');
            return self::SUCCESS;
        }

        foreach ($tenants as $tenant) {
            $this->info('Generating weekly AI agents report for tenant ' . $tenant->id . '...');
            $service->generateForTenant($tenant, $week, $force, $window);
        }

        $this->info('Weekly AI agents report generation complete.');
        return self::SUCCESS;
    }
}
