<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Tenant;
use App\Services\AssetRegisterImportService;

class ImportAssetRegister extends Command
{
    protected $signature = 'import:asset-register {path?} {--tenant=} {--location=} {--sheet=}';

    protected $description = 'Import the asset register XLSX into assets, spares, and links.';

    public function handle(AssetRegisterImportService $importer): int
    {
        $path = $this->argument('path') ?: base_path('Compiled_Asset_Register_with_Spares_and_Budgets_UPDATED_v2.xlsx');
        if (!is_file($path)) {
            $this->error('Asset register file not found: ' . $path);
            return self::FAILURE;
        }

        $tenantId = $this->option('tenant');
        $tenant = $tenantId
            ? Tenant::find($tenantId)
            : Tenant::first();

        if (!$tenant) {
            $this->error('No tenant found to import into.');
            return self::FAILURE;
        }

        $summary = $importer->import(
            $path,
            $tenant->id,
            null,
            $this->option('location'),
            $this->option('sheet')
        );
        $this->info('Import completed.');
        foreach ($summary as $key => $value) {
            $this->line($key . ': ' . $value);
        }

        return self::SUCCESS;
    }
}
