<?php

namespace App\Console\Commands;

use App\Models\Tenant;
use App\Services\FourwaysMaintenanceDataImportService;
use Illuminate\Console\Command;

class ImportFourwaysMaintenancePack extends Command
{
    protected $signature = 'import:fourways-maintenance
        {--tenant=}
        {--strategy=Fourways_Maintenance_Strategy_Pack_2026.xlsx}
        {--cashflow=Fourways_Maintenance_Cashflow_2026_WITH_BACKLOG.xlsx}
        {--concrete=Fourways_Concrete_Weekly_Cashflow_and_Repair_Tracker_WITH_RISK_HEATMAP.xlsx}';

    protected $description = 'Import Fourways maintenance strategy, cashflow, and repair tracker packs.';

    public function handle(FourwaysMaintenanceDataImportService $importer): int
    {
        $tenant = $this->option('tenant')
            ? Tenant::find((int) $this->option('tenant'))
            : Tenant::where('name', 'Fourways Group')->first();

        if (!$tenant) {
            $this->error('Tenant not found. Provide --tenant ID.');
            return self::FAILURE;
        }

        $strategy = base_path($this->option('strategy'));
        $cashflow = base_path($this->option('cashflow'));
        $concrete = base_path($this->option('concrete'));

        if (!is_file($strategy) || !is_file($cashflow) || !is_file($concrete)) {
            $this->error('One or more import files are missing.');
            return self::FAILURE;
        }

        $summary = $importer->importAll($strategy, $cashflow, $concrete, $tenant);
        $this->info('Import completed.');
        $this->line(json_encode($summary));

        return self::SUCCESS;
    }
}
