<?php

namespace App\Console\Commands;

use App\Services\Ai\PoultryAiService;
use Illuminate\Console\Command;

class PoultryEvaluateAlerts extends Command
{
    protected $signature = 'poultry:evaluate-alerts {--house=}';

    protected $description = 'Evaluate poultry alerts for houses.';

    public function handle(PoultryAiService $service): int
    {
        $query = \App\Models\House::query();
        if ($this->option('house')) {
            $query->where('id', $this->option('house'));
        }

        $count = 0;
        foreach ($query->get() as $house) {
            $alerts = $service->evaluateAlerts($house);
            $this->info("House {$house->name}: created " . count($alerts) . ' alerts.');
            $count++;
        }

        if ($count === 0) {
            $this->warn('No houses found.');
        }

        return self::SUCCESS;
    }
}
