<?php

namespace App\Console\Commands;

use App\Models\Tenant;
use App\Services\LinkingReconciliationService;
use Illuminate\Console\Command;

class RunLinkingReconciliation extends Command
{
    protected $signature = 'reconcile:links {--tenant=} {--dry}';

    protected $description = 'Run automated linking and reconciliation for WOs, PMs, PRs, POs, GRNs, and invoices.';

    public function handle(LinkingReconciliationService $service): int
    {
        $tenantOption = $this->option('tenant');
        $dryRun = (bool) $this->option('dry');

        if ($tenantOption) {
            $tenant = Tenant::find((int) $tenantOption);
            if (!$tenant) {
                $this->error('Tenant not found.');
                return self::FAILURE;
            }

            $summary = $service->runForTenant($tenant->id, $dryRun);
            $this->line(json_encode($summary));
            return self::SUCCESS;
        }

        $summary = $service->runAll($dryRun);
        $this->line(json_encode($summary));
        return self::SUCCESS;
    }
}
