<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected $commands = [
        \App\Console\Commands\GenerateWeeklyAiAgentsReport::class,
        \App\Console\Commands\ImportFourwaysMaintenancePack::class,
        \App\Console\Commands\RunLinkingReconciliation::class,
        \App\Console\Commands\PoultrySeedDemo::class,
        \App\Console\Commands\PoultryRunAi::class,
        \App\Console\Commands\PoultryEvaluateAlerts::class,
    ];

    protected function schedule(Schedule $schedule)
    {
        $schedule->job(new \App\Jobs\RunTelegramEventScan())->everyFifteenMinutes();
        $schedule->job(new \App\Jobs\RunTelegramEventEscalation())->everyTenMinutes();
        $schedule->job(new \App\Jobs\SendTelegramApprovalReminders())->everyFourHours();
        $schedule->job(new \App\Jobs\SendTechnicianDailyJobList())->dailyAt('06:30');
        $schedule->job(new \App\Jobs\SendDailyMaintenanceDigest())->dailyAt('07:00');
        $schedule->job(new \App\Jobs\RunMaintenanceComplianceAgent())->dailyAt('14:00');
        $schedule->job(new \App\Jobs\RunOpsNotifierComplianceScanAll())->dailyAt('07:00');
        $schedule->job(new \App\Jobs\RunFinanceOversightAgent())->dailyAt('17:30');
        $schedule->job(new \App\Jobs\RunFailurePredictionAgent())->weeklyOn(3, '09:00');
        $schedule->job(new \App\Jobs\RunHrArtisanPerformanceAgent())->weeklyOn(5, '15:00');
        $schedule->job(new \App\Jobs\RunKpiAnalystAgent())->weeklyOn(5, '16:00');
        $schedule->command('poultry:run-ai --period=daily')->dailyAt('18:00');
        $schedule->command('poultry:run-ai --period=weekly')->weeklyOn(5, '16:00');
        $schedule->command('poultry:evaluate-alerts')->everyFiveMinutes();
        $schedule->command('reports:weekly-ai-agents')
            ->weeklyOn(5, '16:00')
            ->timezone('Africa/Harare');
        $schedule->job(new \App\Jobs\GenerateWeeklyReport())->weeklyOn(1, '06:00');
        $schedule->job(new \App\Jobs\ProcessNotificationOutbox())->everyFiveMinutes();
        $schedule->command('reconcile:links')->dailyAt('03:00')->timezone('Africa/Harare');
    }

    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        if (file_exists(base_path('routes/console.php'))) {
            require base_path('routes/console.php');
        }
    }
}
