<?php

namespace App\Domain\Telegram;

use App\Models\TelegramLink;
use App\Models\User;

class TelegramNotifier
{
    public function __construct(private TelegramApiClient $client)
    {
    }

    public function notifyChat(string $chatId, string $message, ?array $replyMarkup = null): ?string
    {
        $response = $this->client->sendMessage($chatId, $message, $replyMarkup);
        return (string) ($response['message_id'] ?? '');
    }

    public function notifyChatDocument(string $chatId, string $filePath, ?string $filename = null, ?string $caption = null, ?array $replyMarkup = null): ?string
    {
        $response = $this->client->sendDocument($chatId, $filePath, $filename, $caption, $replyMarkup);
        return (string) ($response['message_id'] ?? '');
    }

    public function notifyUser(int $userId, string $message, ?array $replyMarkup = null): bool
    {
        $link = TelegramLink::where('user_id', $userId)->first();
        if (!$link || !$link->telegram_chat_id) {
            return false;
        }

        $this->client->sendMessage((string) $link->telegram_chat_id, $message, $replyMarkup);
        return true;
    }

    public function notifyUserDocument(int $userId, string $filePath, ?string $filename = null, ?string $caption = null, ?array $replyMarkup = null): bool
    {
        $link = TelegramLink::where('user_id', $userId)->first();
        if (!$link || !$link->telegram_chat_id) {
            return false;
        }

        $this->client->sendDocument((string) $link->telegram_chat_id, $filePath, $filename, $caption, $replyMarkup);
        return true;
    }

    public function notifyUsers(iterable $users, string $message): void
    {
        foreach ($users as $user) {
            if ($user instanceof User) {
                $this->notifyUser($user->id, $message);
            }
        }
    }
}
