<?php

namespace App\Exceptions;

use Illuminate\Database\QueryException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;

class Handler extends ExceptionHandler
{
    protected $dontReport = [];

    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });

        $this->renderable(function (QueryException $e, $request) {
            $message = $this->friendlyDatabaseError($e);
            if (!$message) {
                return null;
            }

            if ($request->expectsJson() || $request->is('api/*')) {
                return response()->json(['message' => $message], 500);
            }

            $safe = htmlspecialchars($message, ENT_QUOTES, 'UTF-8');
            $html = "<h1>Setup required</h1><p>{$safe}</p>";
            return response($html, 500)->header('Content-Type', 'text/html; charset=UTF-8');
        });
    }

    private function friendlyDatabaseError(QueryException $e): ?string
    {
        $message = strtolower($e->getMessage());

        if (str_contains($message, 'no such table') || str_contains($message, 'does not exist')) {
            return 'Database schema is missing. Please run migrations: php artisan migrate.';
        }

        if (str_contains($message, 'no column') || str_contains($message, 'unknown column')) {
            return 'Database schema is out of date. Please run migrations: php artisan migrate.';
        }

        return null;
    }
}
