<?php

namespace App\Http\Controllers;

use App\Models\DocumentIntakeBatch;
use App\Models\Tenant;
use App\Services\DocumentIntakeApplyService;
use Illuminate\Http\Request;

class AiIntakeController extends Controller
{
    public function show(Request $request, DocumentIntakeBatch $batch)
    {
        $tenant = $this->resolveTenant($request);
        if (!$tenant || $batch->tenant_id !== $tenant->id) {
            return response()->json(['message' => 'Not found.'], 404);
        }

        $preview = $batch->rows()->limit(10)->get()->map(fn ($row) => [
            'row_index' => $row->row_index,
            'data' => $row->data,
            'errors' => $row->errors,
            'warnings' => $row->warnings,
            'matches' => $row->matches,
        ]);

        return response()->json([
            'batch_id' => $batch->id,
            'doc_type' => $batch->doc_type,
            'status' => $batch->status,
            'summary' => $batch->summary,
            'warnings' => $batch->warnings,
            'preview' => $preview,
        ]);
    }

    public function apply(Request $request, DocumentIntakeBatch $batch)
    {
        $tenant = $this->resolveTenant($request);
        if (!$tenant || $batch->tenant_id !== $tenant->id) {
            return response()->json(['message' => 'Not found.'], 404);
        }

        $summary = app(DocumentIntakeApplyService::class)->applyBatch($batch, $request->user()?->id);

        return response()->json([
            'batch_id' => $batch->id,
            'status' => $batch->status,
            'summary' => $summary,
        ]);
    }

    private function resolveTenant(Request $request): ?Tenant
    {
        if ($request->user()?->tenant_id) {
            return Tenant::find($request->user()->tenant_id);
        }

        $headerTenant = $request->header('X-Tenant-ID') ?: $request->input('tenant_id');
        if ($headerTenant) {
            return Tenant::find($headerTenant);
        }

        return Tenant::where('name', 'Fourways Group')->first() ?? Tenant::first();
    }
}
