<?php

namespace App\Http\Controllers;

use App\Models\Alarm;
use App\Services\AuditService;
use Illuminate\Http\Request;

class AlarmController extends Controller
{
    public function index()
    {
        return Alarm::with(['asset', 'rule'])->latest()->get();
    }

    public function acknowledge(Request $request, Alarm $alarm)
    {
        $alarm->update([
            'status' => 'acknowledged',
            'acknowledged_by' => $request->user()->id,
            'acknowledged_at' => now(),
        ]);

        app(AuditService::class)->log(
            'alarm.acknowledged',
            Alarm::class,
            $alarm->id,
            ['status' => 'acknowledged'],
            $request->user()->tenant_id,
            $request->user()->id,
            $request
        );

        return response()->json($alarm);
    }
}
