<?php

namespace App\Http\Controllers;

use App\Models\AlarmRule;
use Illuminate\Http\Request;

class AlarmRuleController extends Controller
{
    public function index()
    {
        return AlarmRule::latest()->get();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'metric' => 'nullable|string|max:100',
            'comparison' => 'nullable|string|max:10',
            'threshold' => 'nullable|numeric',
            'severity' => 'nullable|string|max:50',
            'conditions' => 'nullable|array',
            'schedule' => 'nullable|array',
            'actions' => 'nullable|array',
            'enabled' => 'nullable|boolean',
        ]);

        $data['created_by'] = $request->user()->id;

        $rule = AlarmRule::create($data);

        return response()->json($rule, 201);
    }
}
