<?php

namespace App\Http\Controllers;

use App\Models\Checklist;
use Illuminate\Http\Request;

class ChecklistController extends Controller
{
    public function index()
    {
        return Checklist::latest()->get();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'type' => 'nullable|string|max:100',
            'items' => 'nullable|array',
            'active' => 'nullable|boolean',
        ]);

        $checklist = Checklist::create($data);

        return response()->json($checklist, 201);
    }
}
