<?php

namespace App\Http\Controllers;

use App\Models\DowntimeReasonCode;
use Illuminate\Http\Request;

class DowntimeReasonController extends Controller
{
    public function index()
    {
        return DowntimeReasonCode::orderBy('label')->get();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'code' => 'nullable|string|max:50',
            'label' => 'required|string|max:255',
            'active' => 'nullable|boolean',
        ]);

        $reason = DowntimeReasonCode::create($data);

        return response()->json($reason, 201);
    }
}
