<?php

namespace App\Http\Controllers;

use App\Models\FuelLog;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class FuelLogController extends Controller
{
    public function index()
    {
        return FuelLog::with(['asset', 'site'])->latest()->get();
    }

    public function store(Request $request)
    {
        $tenantId = $request->user()->tenant_id;
        $data = $request->validate([
            'asset_id' => [
                'required',
                Rule::exists('assets', 'id')->where('tenant_id', $tenantId),
            ],
            'site_id' => [
                'nullable',
                Rule::exists('sites', 'id')->where('tenant_id', $tenantId),
            ],
            'operator_id' => [
                'nullable',
                Rule::exists('users', 'id')->where('tenant_id', $tenantId),
            ],
            'source' => 'nullable|string',
            'fuel_type' => 'nullable|string',
            'quantity' => 'nullable|numeric',
            'unit_cost' => 'nullable|numeric',
            'total_cost' => 'nullable|numeric',
            'expected_quantity' => 'nullable|numeric',
            'variance' => 'nullable|numeric',
            'meter_reading' => 'nullable|numeric',
            'logged_at' => 'nullable|date',
            'notes' => 'nullable|string',
        ]);

        $fuelLog = FuelLog::create($data);

        return response()->json($fuelLog, 201);
    }
}
