<?php

namespace App\Http\Controllers;

use App\Jobs\ProcessImportBatch;
use App\Models\ImportBatch;
use App\Services\ImportService;
use App\Services\AuditService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ImportController extends Controller
{
    public function index()
    {
        return ImportBatch::with('rows')->latest()->get();
    }

    public function store(Request $request, ImportService $service)
    {
        $request->validate([
            'file' => 'required|file',
            'import_type' => 'nullable|string|in:assets,service_sheets,invoices',
        ]);

        $batch = $service->createBatch(
            $request->file('file'),
            Auth::user()->tenant_id,
            Auth::id(),
            $request->input('import_type', 'assets')
        );

        app(AuditService::class)->log(
            'import.created',
            ImportBatch::class,
            $batch->id,
            ['file_path' => $batch->file_path],
            Auth::user()->tenant_id,
            Auth::id(),
            $request
        );

        ProcessImportBatch::dispatch($batch->id);

        return response()->json($batch, 201);
    }

    public function show(ImportBatch $importBatch)
    {
        return $importBatch->load('rows');
    }
}
