<?php

namespace App\Http\Controllers;

use App\Models\InventoryItem;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class InventoryItemController extends Controller
{
    public function index()
    {
        return InventoryItem::with(['part', 'location'])->latest()->get();
    }

    public function store(Request $request)
    {
        $tenantId = $request->user()->tenant_id;
        $data = $request->validate([
            'part_id' => [
                'required',
                Rule::exists('parts', 'id')->where('tenant_id', $tenantId),
            ],
            'location_id' => [
                'nullable',
                Rule::exists('inventory_locations', 'id')->where('tenant_id', $tenantId),
            ],
            'quantity' => 'nullable|numeric',
            'min_quantity' => 'nullable|numeric',
            'max_quantity' => 'nullable|numeric',
            'reorder_point' => 'nullable|numeric',
        ]);

        $item = InventoryItem::create($data);

        return response()->json($item, 201);
    }
}
