<?php

namespace App\Http\Controllers;

use App\Models\InventoryLocation;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class InventoryLocationController extends Controller
{
    public function index()
    {
        return InventoryLocation::with('site')->orderBy('name')->get();
    }

    public function store(Request $request)
    {
        $tenantId = $request->user()->tenant_id;
        $data = $request->validate([
            'site_id' => [
                'nullable',
                Rule::exists('sites', 'id')->where('tenant_id', $tenantId),
            ],
            'name' => 'required|string|max:255',
            'code' => 'nullable|string|max:50',
        ]);

        $location = InventoryLocation::create($data);

        return response()->json($location, 201);
    }
}
