<?php

namespace App\Http\Controllers;

use App\Models\NotificationChannel;
use Illuminate\Http\Request;

class NotificationChannelController extends Controller
{
    public function index()
    {
        return NotificationChannel::latest()->get();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'type' => 'required|string|max:50',
            'name' => 'nullable|string|max:255',
            'credentials_encrypted' => 'nullable|string',
            'enabled' => 'nullable|boolean',
        ]);

        $channel = NotificationChannel::create($data);

        return response()->json($channel, 201);
    }
}
