<?php

namespace App\Http\Controllers;

use App\Models\NotificationRoute;
use Illuminate\Http\Request;

class NotificationRouteController extends Controller
{
    public function index()
    {
        return NotificationRoute::latest()->get();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'event_type' => 'required|string|max:255',
            'channel_order' => 'nullable|array',
            'recipients' => 'nullable|array',
            'quiet_hours' => 'nullable|array',
            'escalation_minutes' => 'nullable|integer',
        ]);

        $route = NotificationRoute::create($data);

        return response()->json($route, 201);
    }
}
