<?php

namespace App\Http\Controllers;

use App\Models\PmSchedule;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class PmScheduleController extends Controller
{
    public function index()
    {
        return PmSchedule::with('asset')->latest()->get();
    }

    public function store(Request $request)
    {
        $tenantId = $request->user()->tenant_id;
        $data = $request->validate([
            'asset_id' => [
                'required',
                Rule::exists('assets', 'id')->where('tenant_id', $tenantId),
            ],
            'name' => 'required|string|max:255',
            'schedule_type' => 'nullable|string|max:50',
            'interval_value' => 'nullable|integer',
            'interval_unit' => 'nullable|string|max:50',
            'meter_type' => 'nullable|string|max:50',
            'last_meter_reading' => 'nullable|numeric',
            'next_meter_reading' => 'nullable|numeric',
            'last_service_at' => 'nullable|date',
            'next_due_at' => 'nullable|date',
            'active' => 'nullable|boolean',
        ]);

        $schedule = PmSchedule::create($data);

        return response()->json($schedule, 201);
    }
}
