<?php

namespace App\Http\Controllers;

use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;

class RoleController extends Controller
{
    public function index()
    {
        return Role::latest()->get();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:100',
            'description' => 'nullable|string|max:255',
        ]);

        $role = Role::create($data);

        return response()->json($role, 201);
    }

    public function assign(Request $request, User $user)
    {
        $data = $request->validate([
            'role_ids' => 'required|array',
            'role_ids.*' => 'exists:roles,id',
        ]);

        $tenantId = $request->user()->tenant_id;
        if ($user->tenant_id !== $tenantId) {
            return response()->json(['message' => 'User not in tenant.'], 403);
        }

        $roleIds = Role::where('tenant_id', $tenantId)
            ->whereIn('id', $data['role_ids'])
            ->pluck('id')
            ->all();

        $user->roles()->sync($roleIds);

        return response()->json($user->load('roles'));
    }
}
