<?php

namespace App\Http\Controllers\Telegram;

use App\Domain\Telegram\TelegramLinkService;
use Illuminate\Http\Request;

class TelegramLinkController
{
    public function link(Request $request, TelegramLinkService $linkService)
    {
        $data = $request->validate([
            'code' => 'required|string',
            'telegram_user_id' => 'required|string',
            'chat_id' => 'nullable|string',
        ]);

        $result = $linkService->linkByCode($data['code'], $data['telegram_user_id'], $data['chat_id'] ?? null);

        if (!$result['linked']) {
            return response()->json(['message' => $result['message']], 422);
        }

        return response()->json(['message' => $result['message']]);
    }
}
