<?php

namespace App\Http\Controllers;

use App\Models\Tyre;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class TyreController extends Controller
{
    public function index()
    {
        return Tyre::with('asset')->latest()->get();
    }

    public function store(Request $request)
    {
        $tenantId = $request->user()->tenant_id;
        $data = $request->validate([
            'asset_id' => [
                'required',
                Rule::exists('assets', 'id')->where('tenant_id', $tenantId),
            ],
            'position' => 'nullable|string',
            'serial_number' => 'nullable|string',
            'brand' => 'nullable|string',
            'model' => 'nullable|string',
            'tread_depth' => 'nullable|numeric',
            'status' => 'nullable|string',
            'installed_at' => 'nullable|date',
            'removed_at' => 'nullable|date',
            'failure_reason' => 'nullable|string',
            'notes' => 'nullable|string',
        ]);

        $tyre = Tyre::create($data);

        return response()->json($tyre, 201);
    }
}
