<?php

namespace App\Http\Controllers;

use App\Models\Vehicle;
use Illuminate\Http\Request;

class VehicleController extends Controller
{
    public function index()
    {
        $tenantId = auth()->user()->tenant_id;
        $vehicles = Vehicle::where('tenant_id', $tenantId)->get();
        return response()->json($vehicles);
    }

    public function show($id)
    {
        $tenantId = auth()->user()->tenant_id;
        $vehicle = Vehicle::where('tenant_id', $tenantId)->findOrFail($id);
        return response()->json($vehicle);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'license_plate' => 'required|string|max:20|unique:vehicles',
            'asset_id' => 'nullable|exists:assets,id',
            'site_id' => 'nullable|exists:sites,id',
            'type' => 'nullable|string|max:100',
            'status' => 'nullable|string|max:50',
            'odometer' => 'nullable|numeric',
            'engine_hours' => 'nullable|numeric',
        ]);

        $data = $request->all();
        $data['tenant_id'] = $request->user()->tenant_id;

        $vehicle = Vehicle::create($data);
        return response()->json($vehicle, 201);
    }

    public function update(Request $request, $id)
    {
        $tenantId = $request->user()->tenant_id;
        $vehicle = Vehicle::where('tenant_id', $tenantId)->findOrFail($id);

        $request->validate([
            'name' => 'sometimes|required|string|max:255',
            'license_plate' => 'sometimes|required|string|max:20|unique:vehicles,license_plate,' . $vehicle->id,
            'asset_id' => 'nullable|exists:assets,id',
            'site_id' => 'nullable|exists:sites,id',
            'type' => 'nullable|string|max:100',
            'status' => 'nullable|string|max:50',
            'odometer' => 'nullable|numeric',
            'engine_hours' => 'nullable|numeric',
        ]);

        $vehicle->update($request->all());
        return response()->json($vehicle);
    }

    public function destroy($id)
    {
        $tenantId = auth()->user()->tenant_id;
        $vehicle = Vehicle::where('tenant_id', $tenantId)->findOrFail($id);
        $vehicle->delete();
        return response()->json(null, 204);
    }
}
