<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Alert;
use App\Models\House;
use Illuminate\Http\Request;

class AlertController extends Controller
{
    public function index(Request $request)
    {
        $query = Alert::query()->with('house');

        if ($request->filled('severity')) {
            $query->where('severity', $request->input('severity'));
        }
        if ($request->filled('status')) {
            $query->where('status', $request->input('status'));
        }
        if ($request->filled('house_id')) {
            $query->where('house_id', $request->input('house_id'));
        }

        $alerts = $query->orderByDesc('created_at')->paginate(20);
        $houses = House::orderBy('name')->get();

        return view('poultry.alerts', [
            'alerts' => $alerts,
            'houses' => $houses,
        ]);
    }
}
