<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\AiReport;
use App\Models\House;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function index(Request $request)
    {
        $query = AiReport::where('report_type', 'poultry_ops')->with('house');
        if ($request->filled('house_id')) {
            $query->where('house_id', $request->input('house_id'));
        }
        if ($request->filled('period')) {
            $query->where('period', $request->input('period'));
        }

        $reports = $query->orderByDesc('created_at')->paginate(20);
        $houses = House::orderBy('name')->get();

        return view('poultry.reports', [
            'reports' => $reports,
            'houses' => $houses,
        ]);
    }

    public function show(AiReport $report)
    {
        return view('poultry.report-show', [
            'report' => $report,
        ]);
    }
}
