<?php

namespace App\Http\Middleware;

use App\Models\Device;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class DeviceApiKeyMiddleware
{
    public function handle(Request $request, Closure $next): Response
    {
        $apiKey = (string) $request->header('X-DEVICE-KEY');
        if ($apiKey === '') {
            return response()->json(['message' => 'Missing device API key.'], 401);
        }

        $device = Device::where('api_key', $apiKey)->first();
        if (!$device) {
            return response()->json(['message' => 'Invalid device API key.'], 401);
        }

        $device->last_seen_at = now('UTC');
        $device->save();

        $request->attributes->set('device', $device);
        if ($device->house_id) {
            $request->attributes->set('house', $device->house);
        }

        return $next($request);
    }
}
