<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TenantMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            abort(401, 'Unauthorized.');
        }

        $user = Auth::user();
        if (!$user->tenant_id || !$user->tenant) {
            abort(403, 'Tenant context missing.');
        }

        $tenant = $user->tenant;

        // Set the tenant context for the application
        app()->instance('tenant', $tenant);

        return $next($request);
    }
}
