<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateAssetRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:255',
            'type' => 'required|string|max:255',
            'tenant_id' => 'required|exists:tenants,id',
            'purchase_date' => 'required|date',
            'status' => 'required|string|in:active,inactive',
        ];
    }
}
