<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class IngestTelemetryDataRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'vehicle_id' => 'required|exists:vehicles,id',
            'data' => 'required|array',
            'data.*.timestamp' => 'required|date',
            'data.*.value' => 'required|numeric',
        ];
    }
}
