<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateTenantRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => 'sometimes|required|string|max:255',
            'email' => 'sometimes|required|email|unique:tenants,email,' . $this->tenant->id,
            'subdomain' => 'sometimes|required|string|max:255|unique:tenants,subdomain,' . $this->tenant->id,
        ];
    }
}
