<?php

namespace App\Jobs;

use App\Services\AiAutomationService;
use App\Services\TelemetryIngestionService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessTelemetryData implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $telemetryData;

    public function __construct(array $telemetryData)
    {
        $this->telemetryData = $telemetryData;
    }

    public function handle(TelemetryIngestionService $ingestionService, AiAutomationService $automationService)
    {
        $telemetry = $ingestionService->ingest($this->telemetryData);

        $automationService->triggerAutomation($telemetry);
    }
}
