<?php

namespace App\Jobs;

use App\Services\AiAgentService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class RunCostControlAgent implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public int $tenantId,
        public string $source,
        public ?int $sourceId = null
    ) {
    }

    public function handle(AiAgentService $service): void
    {
        $service->runCostControl($this->tenantId, $this->source, $this->sourceId);
    }
}
