<?php

namespace App\Jobs;

use App\Services\OpsNotifierAgent;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class RunOpsNotifierComplianceScan implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(public int $tenantId)
    {
    }

    public function handle(OpsNotifierAgent $agent): void
    {
        $agent->runComplianceScan($this->tenantId);
    }
}
