<?php

namespace App\Jobs;

use App\Models\Asset;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ScheduleMaintenanceJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $assetId;

    public function __construct(int $assetId)
    {
        $this->assetId = $assetId;
    }

    public function handle()
    {
        $asset = Asset::find($this->assetId);
        if ($asset) {
            // Schedule maintenance logic here
        }
    }
}
