<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Http;

class SendTelegramMessage implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(private string $chatId, private string $text)
    {
    }

    public function handle(): void
    {
        $token = config('services.telegram.bot_token');
        if (!$token) {
            return;
        }

        $url = 'https://api.telegram.org/bot' . $token . '/sendMessage';
        Http::timeout(15)->post($url, [
            'chat_id' => $this->chatId,
            'text' => $this->text,
            'disable_web_page_preview' => true,
        ]);
    }
}
