<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AgentNotification extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'agent_key',
        'agent_name',
        'severity',
        'title',
        'summary',
        'payload',
        'recipients',
        'status',
        'sent_at',
    ];

    protected $casts = [
        'payload' => 'array',
        'recipients' => 'array',
        'sent_at' => 'datetime',
    ];
}
