<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AiToolLog extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'user_id',
        'conversation_id',
        'upload_id',
        'tool_name',
        'action',
        'target_type',
        'target_id',
        'input',
        'output',
        'status',
        'source',
    ];

    protected $casts = [
        'input' => 'array',
        'output' => 'array',
    ];
}
