<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class AlarmRule extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'name',
        'metric',
        'comparison',
        'threshold',
        'severity',
        'conditions',
        'schedule',
        'actions',
        'enabled',
        'created_by',
    ];

    protected $casts = [
        'threshold' => 'float',
        'conditions' => 'array',
        'schedule' => 'array',
        'actions' => 'array',
        'enabled' => 'boolean',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function alarms()
    {
        return $this->hasMany(Alarm::class, 'rule_id');
    }
}
