<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Alert extends Model
{
    use HasFactory;

    protected $fillable = [
        'house_id',
        'severity',
        'category',
        'title',
        'message',
        'status',
        'suggested_actions_json',
    ];

    protected $casts = [
        'suggested_actions_json' => 'array',
    ];

    public function house()
    {
        return $this->belongsTo(House::class);
    }
}
