<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Concerns\BelongsToTenant;

class Asset extends Model
{
    use HasFactory, SoftDeletes, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'name',
        'description',
        'status',
        'fit_for_purpose',
        'plant_restrictions',
        'comments',
        'asset_tag',
        'make',
        'model',
        'serial_number',
        'year',
        'category',
        'asset_type',
        'lifecycle_status',
        'commissioned_at',
        'purchase_date',
        'warranty_expiry',
        'location',
        'site_id',
        'current_value',
        'maintenance_interval',
        'service_frequency',
        'next_review_at',
        'source',
        'spare_tags',
        'top_spares',
        'yearly_budget',
        'daily_budget',
        'weekly_budget',
        'monthly_budget',
        'meter_type',
        'meter_reading',
    ];

    protected $dates = [
        'commissioned_at',
        'purchase_date',
        'warranty_expiry',
        'next_review_at',
    ];

    protected $casts = [
        'current_value' => 'float',
        'maintenance_interval' => 'integer',
        'fit_for_purpose' => 'boolean',
        'yearly_budget' => 'float',
        'daily_budget' => 'float',
        'weekly_budget' => 'float',
        'monthly_budget' => 'float',
        'meter_reading' => 'float',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function site()
    {
        return $this->belongsTo(Site::class);
    }

    public function assignments()
    {
        return $this->hasMany(AssetAssignment::class);
    }

    public function documents()
    {
        return $this->hasMany(AssetDocument::class);
    }

    public function spares()
    {
        return $this->hasMany(AssetSpare::class);
    }

    public function workOrders()
    {
        return $this->hasMany(WorkOrder::class);
    }

    public function pmSchedules()
    {
        return $this->hasMany(PmSchedule::class);
    }

    public function fuelLogs()
    {
        return $this->hasMany(FuelLog::class);
    }

    public function tyres()
    {
        return $this->hasMany(Tyre::class);
    }

    public function devices()
    {
        return $this->hasMany(Device::class);
    }

    public function maintenanceRecords()
    {
        return $this->hasMany(Maintenance::class);
    }

    public function trips()
    {
        return $this->hasMany(Trip::class);
    }

    public function telemetryData()
    {
        return $this->hasMany(Telemetry::class);
    }

    public function scheduleMaintenance($date, $details)
    {
        // Logic for scheduling maintenance
    }

    public function updateAssetValue($newValue)
    {
        $this->current_value = $newValue;
        $this->save();
    }

    public function lifecycleStatus()
    {
        // Logic to determine the lifecycle status of the asset
    }
}
