<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class AssetSpare extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'asset_id',
        'part_id',
        'quantity',
        'unit_cost',
        'replacement_frequency',
        'estimated_replacements_per_year',
        'cost_per_year',
    ];

    protected $casts = [
        'quantity' => 'float',
        'unit_cost' => 'float',
        'estimated_replacements_per_year' => 'float',
        'cost_per_year' => 'float',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function part()
    {
        return $this->belongsTo(Part::class);
    }
}
