<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CamFrame extends Model
{
    use HasFactory;

    protected $fillable = [
        'house_id',
        'device_id',
        'ts',
        'path',
        'meta_json',
    ];

    protected $casts = [
        'ts' => 'datetime',
        'meta_json' => 'array',
    ];

    public function house()
    {
        return $this->belongsTo(House::class);
    }

    public function device()
    {
        return $this->belongsTo(Device::class);
    }
}
