<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ComplianceRecord extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'asset_id',
        'vehicle_id',
        'compliance_type',
        'expiry_date',
        'status',
        'last_notified_at',
        'meta_json',
    ];

    protected $casts = [
        'expiry_date' => 'date',
        'last_notified_at' => 'datetime',
        'meta_json' => 'array',
    ];

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }
}
