<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class Device extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'asset_id',
        'house_id',
        'name',
        'type',
        'identifier',
        'api_key',
        'firmware_version',
        'meta',
        'last_seen_at',
    ];

    protected $casts = [
        'meta' => 'array',
        'last_seen_at' => 'datetime',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function house()
    {
        return $this->belongsTo(House::class);
    }

    public function rawEvents()
    {
        return $this->hasMany(SensorEventRaw::class);
    }
}
