<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DocumentIntakeBatch extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'conversation_id',
        'user_id',
        'doc_type',
        'status',
        'schema_version',
        'summary',
        'warnings',
        'source_upload_ids',
        'processed_at',
    ];

    protected $casts = [
        'summary' => 'array',
        'warnings' => 'array',
        'source_upload_ids' => 'array',
        'processed_at' => 'datetime',
    ];

    public function conversation()
    {
        return $this->belongsTo(ChatConversation::class, 'conversation_id');
    }

    public function rows()
    {
        return $this->hasMany(DocumentIntakeRow::class, 'batch_id');
    }
}
