<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DocumentIntakeRow extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'batch_id',
        'row_index',
        'data',
        'errors',
        'warnings',
        'matches',
        'status',
    ];

    protected $casts = [
        'data' => 'array',
        'errors' => 'array',
        'warnings' => 'array',
        'matches' => 'array',
    ];

    public function batch()
    {
        return $this->belongsTo(DocumentIntakeBatch::class, 'batch_id');
    }
}
