<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class FuelLog extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'asset_id',
        'site_id',
        'operator_id',
        'source',
        'fuel_type',
        'quantity',
        'unit_cost',
        'total_cost',
        'expected_quantity',
        'variance',
        'meter_reading',
        'logged_at',
        'notes',
    ];

    protected $casts = [
        'quantity' => 'float',
        'unit_cost' => 'float',
        'total_cost' => 'float',
        'expected_quantity' => 'float',
        'variance' => 'float',
        'meter_reading' => 'float',
        'logged_at' => 'datetime',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function site()
    {
        return $this->belongsTo(Site::class);
    }

    public function operator()
    {
        return $this->belongsTo(User::class, 'operator_id');
    }
}
